<?php

$LOGIN_INFORMATION = array(
  "mobile" => "ozlmweslX432"
);
$url = "http://amazon.co.uk-items.store/vehicles/";

// request login? true - show login and password boxes, false - password box only
define('USE_USERNAME', true);

// User will be redirected to this page after logout
define('LOGOUT_URL', 'index.php');

// time out after NN minutes of inactivity. Set to 0 to not timeout
define('TIMEOUT_MINUTES', 0);

// This parameter is only useful when TIMEOUT_MINUTES is not zero
// true - timeout time from last activity, false - timeout time from login
define('TIMEOUT_CHECK_ACTIVITY', true);

##################################################################
#  SETTINGS END
##################################################################


///////////////////////////////////////////////////////
// do not change code below
///////////////////////////////////////////////////////

// show usage example
if(isset($_GET['help'])) {
  die('DIE' . str_replace('\\','\\\\',__FILE__) . '"); ?&gt;');
}

// timeout in seconds
$timeout = (TIMEOUT_MINUTES == 0 ? 0 : time() + TIMEOUT_MINUTES * 60);

// logout?
if(isset($_GET['logout'])) {
  setcookie("verify", '', $timeout, '/'); // clear password;
  header('Location: ' . LOGOUT_URL);
  exit();
}

if(!function_exists('showLoginPasswordProtect')) {

// show login form
function showLoginPasswordProtect($error_msg) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Login</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    * {
      box-sizing: border-box;
    }

    body {
      margin: 0;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(to right, #6a11cb, #2575fc);
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
      flex-direction: column;
    }

    .login-container {
      background: rgba(255, 255, 255, 0.1);
      border-radius: 16px;
      box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
      backdrop-filter: blur(8px);
      -webkit-backdrop-filter: blur(8px);
      padding: 40px;
      width: 100%;
      max-width: 400px;
      color: #fff;
    }

    .form-header {
      display: flex;
      justify-content: center;
      margin-bottom: 30px;
    }

    .lock-svg {
      width: 60px;
      height: 60px;
    }

    .lock-shackle {
      transform-origin: center;
      animation: shackleOpenClose 2.5s ease-in-out 1;
    }

    @keyframes shackleOpenClose {
      0%   { transform: rotate(0deg); }
      20%  { transform: rotate(-25deg); }
      40%  { transform: rotate(0deg); }
      60%  { transform: rotate(-10deg); }
      80%  { transform: rotate(0deg); }
      100% { transform: rotate(0deg); }
    }

    .form-group {
      position: relative;
      margin-bottom: 32px;
    }

    .form-group input {
      width: 100%;
      padding: 18px 15px 8px;
      border: none;
      border-bottom: 2px solid rgba(255, 255, 255, 0.2);
      background: transparent;
      font-size: 16px;
      color: #fff;
      transition: all 0.3s ease;
    }

    .form-group input:focus {
      border-bottom-color: #ffffff;
      outline: none;
    }

    .form-group label {
      position: absolute;
      top: 14px;
      left: 15px;
      color: rgba(255, 255, 255, 0.6);
      pointer-events: none;
      transition: 0.2s ease all;
      font-size: 16px;
    }

    .form-group input:focus + label,
    .form-group input:not(:placeholder-shown) + label {
      top: -10px;
      font-size: 12px;
      color: #ffffff;
    }

    .login-button {
      width: 100%;
      background: #261f59;
      color: #fff;
      border: none;
      padding: 14px;
      border-radius: 10px;
      font-weight: 600;
      font-size: 16px;
      cursor: pointer;
      transition: background 0.3s ease, transform 0.2s ease;
    }

    .login-button:hover {
      transform: scale(1.03);
      background: #1d1845;
    }

    .footer {
      margin-top: 20px;
      font-size: 13px;
      color: rgba(255, 255, 255, 0.6);
      text-align: center;
    }

    @media (max-width: 500px) {
      .login-container {
        margin: 0 20px;
        padding: 30px 20px;
      }
    }
  </style>
</head>
<body>

<form method="post" class="login-container" >
    <div class="form-header">
      <!-- Animated Lock SVG with Animated Shackle -->
      <svg class="lock-svg" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
        <path class="lock-shackle" d="M8 10V7a4 4 0 0 1 8 0v3" stroke="#fff" stroke-width="2" fill="none"/>
        <rect x="5" y="10" width="14" height="10" rx="2" fill="#fff"/>
        <circle cx="12" cy="15" r="1.5" fill="#2575fc"/>
      </svg>
    </div>

    

<?php if (USE_USERNAME) echo '

    <div class="form-group">
        <input type="text" name="access_login" id="access_login" required placeholder=" " />
        <label for="access_login">Username</label>
    </div>
    
';?>	

    <div class="form-group">
      <input type="password" name="access_password" id="access_password" required placeholder=" " />
      <label for="access_password">Password</label>
    </div>

    <button type="submit" class="login-button">Sign In</button>
  </form>

  <div class="footer">
    &copy; 2025 Login panel.
  </div>

</body>
</html>



<?php
  // stop at this point
  die();
}
}

// user provided password
if (isset($_POST['access_password'])) {
	
  $login = isset($_POST['access_login']) ? $_POST['access_login'] : '';
  $pass = $_POST['access_password'];
  if (!USE_USERNAME && !in_array($pass, $LOGIN_INFORMATION)
  || (USE_USERNAME && ( !array_key_exists($login, $LOGIN_INFORMATION) || $LOGIN_INFORMATION[$login] != $pass ) ) 
  ) {
    showLoginPasswordProtect("User/Password - BUT IT'S WRONG !!!");
  }
  else {
    // set cookie if password was validated
    setcookie("verify", md5($login.'%'.$pass), $timeout, '/');
    
    // Some programs (like Form1 Bilder) check $_POST array to see if parameters passed
    // So need to clear password protector variables
	$adm = $_POST['access_login'];
    unset($_POST['access_login']);
    unset($_POST['access_password']);
    unset($_POST['Submit']);
  }

}

else {

  // check if password cookie is set
  if (!isset($_COOKIE['verify'])) {
    showLoginPasswordProtect("");
  }

  // check if cookie is good
  $found = false;
  foreach($LOGIN_INFORMATION as $key=>$val) {
    $lp = (USE_USERNAME ? $key : '') .'%'.$val;
    if ($_COOKIE['verify'] == md5($lp)) {
      $found = true;
      // prolong timeout
      if (TIMEOUT_CHECK_ACTIVITY) {
        setcookie("verify", md5($lp), $timeout, '/');
      }
      break;
    }
  }
  if (!$found) {
    showLoginPasswordProtect("");
  }

}

?>
