<?php
function getVisitorIP() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        return $_SERVER['HTTP_CF_CONNECTING_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } else {
        return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    }
}

function getCountryCodeFromIP($ip) {
    $cacheFile = __DIR__ . '/ip_cache/' . md5($ip) . '.json';

    // Check cache (valid for 24 hours)
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < 86400)) {
        $cached = json_decode(file_get_contents($cacheFile), true);
        if (isset($cached['country'])) {
            return $cached['country'];
        }
    }

    // Fetch from ipinfo.io
    $apiUrl = "https://ipinfo.io/{$ip}/json";
    $response = @file_get_contents($apiUrl);

    if ($response !== false) {
        $data = json_decode($response, true);
        if (isset($data['country'])) {
            if (!is_dir(__DIR__ . '/ip_cache')) {
                mkdir(__DIR__ . '/ip_cache', 0755, true);
            }
            file_put_contents($cacheFile, $response);
            return $data['country'];
        }
    }

    return null;
}

// --- Usage Example ---
$ip = getVisitorIP();
$allowedCountry = 'DE'; // Change this to the ISO country code you want to allow
$visitorCountry = getCountryCodeFromIP($ip);

if ($visitorCountry !== $allowedCountry) {
    http_response_code(500);
    exit("Internal Server Error");
}


?>