<?php

header('Content-Type: text/html; charset=utf-8');

if (!function_exists('generateRandomClassName')) {
    function generateRandomClassName() {
        $prefixLength = rand(5, 10); // Random length between 5 and 10
        $prefix = substr(bin2hex(random_bytes($prefixLength)), 0, $prefixLength); // Generate random prefix
        return $prefix . '_' . bin2hex(random_bytes(5));
    }
}

function addRandomClassesToDiv($line) {
    if (preg_match('/<div([^>]*)class=["\']([^"\']*)["\']([^>]*)>/i', $line, $matches)) {
        if (strpos($matches[2], 'err3') !== false) {
            return $line; 
        }

        $existingClasses = explode(' ', $matches[2]);
        $randomClasses = [];
        $numRandomClasses = rand(1, 3);

        for ($i = 0; $i < $numRandomClasses; $i++) {
            $randomClasses[] = generateRandomClassName();
        }

        $allClasses = array_merge($existingClasses, $randomClasses);
        shuffle($allClasses);

        $newClasses = implode(' ', $allClasses);
        $newLine = preg_replace('/<div([^>]*)class=["\'][^"\']*["\']([^>]*)>/i', "<div$1class='$newClasses'$2>", $line);
        return $newLine;
    }
    return $line;
}

function addRandomSpansToText($line) {
    return preg_replace_callback('/>([^<]+)</u', function ($matches) {
        $text = $matches[1];
        $newText = '';

        foreach (preg_split('//u', $text, -1, PREG_SPLIT_NO_EMPTY) as $char) {
            if (rand(0, 1)) {
                $randomClass = generateRandomClassName();
                $newText .= "<span class='$randomClass'></span>";
            }
            $newText .= $char;
        }

        return ">{$newText}<";
    }, $line);
}

function insertRandomDivsInBody($content) {
    if (preg_match('/<body[^>]*>(.*?)<\/body>/is', $content, $matches)) {
        $bodyContent = $matches[1];

        preg_match_all('/<script.*?>.*?<\/script>/is', $bodyContent, $scriptMatches);
        $scripts = $scriptMatches[0];
        $placeholders = [];

        foreach ($scripts as $index => $script) {
            $placeholder = "<!--SCRIPT_PLACEHOLDER_$index-->";
            $bodyContent = str_replace($script, $placeholder, $bodyContent);
            $placeholders[$placeholder] = $script;
        }

        $lines = explode("\n", $bodyContent);
        $newContent = [];

        foreach ($lines as $line) {
            if (trim($line) !== "") {
                $line = addRandomClassesToDiv($line);
                //$line = addRandomSpansToText($line);
                $line = addNoiseTagsToText($line);
                $newContent[] = $line;

                if (rand(0, 1)) {
                    $randomClass = generateRandomClassName();
                    $newContent[] = "<div class='$randomClass' style='display:inline-block;'></div>";
                }
            }
        }

        $newContent = implode("\n", $newContent);

        foreach ($placeholders as $placeholder => $script) {
            $newContent = str_replace($placeholder, $script, $newContent);
        }

        $content = preg_replace('/<body[^>]*>.*?<\/body>/is', "<body>\n$newContent</body>", $content);
    }
    return $content;
}


function addNoiseTagsToText($line) {
    return preg_replace_callback('/>([^<]+)</u', function ($matches) {
        $text = $matches[1];
        $newText = '';

        foreach (preg_split('//u', $text, -1, PREG_SPLIT_NO_EMPTY) as $char) {
            if (rand(0, 2) === 0) { // 1 in 3 chance to insert noise
                $noiseTag = generateRandomNoiseTag();
                $newText .= $noiseTag;
            }
            $newText .= $char;
        }

        return ">{$newText}<";
    }, $line);
}

function generateRandomNoiseTag() {
    $tags = ['span', 'b', 'u', 'i', 'em', 'strong', 'small'];
    $tag = $tags[array_rand($tags)];
    $randomClass = generateRandomClassName();

    // Randomly sometimes self-closing noise
    if (rand(0, 1)) {
        return "<$tag class='$randomClass'></$tag>";
    } else {
        return "<$tag class='$randomClass'></$tag>";
    }
}



ob_start();
include('main_o.php');
$content = ob_get_clean();

$content = insertRandomDivsInBody($content);

echo $content;

?>